 ; Ŀ
 ;   Trx - draw a cable tray end view.                                     
 ;   Copyright 1994, 1998, 2006 by Rocket Software Ltd.                    
 ;                                                                         
 ; 
 (DEFUN C:TRX ( / *error* osmo blip aa cc bb dd ht wdth)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (if clay (setvar "clayer" clay))
   (setvar "blipmode" blip)
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Set the tray layer current.                                           
 ; 
  (setq clay (getvar "clayer"))
  (if (tblsearch "layer" "tray")
      (setvar "clayer" "tray")
      (command "layer" "m" "tray" "c" "2" "" ""))
  (setq aa (getpoint "First corner:"))
  (if (setq cc (getcorner aa "\nOpposite corner or <Return> to specify: "))
     (progn
          (setq bb (cons (car cc) (cdr aa)))
          (setq dd (cons (car aa) (cdr cc)))
          (command "pline" aa bb cc dd aa cc bb dd ""))
     (progn
          (setq wdth (getdist aa "\nWidth: "))
          (setq ht (getdist aa "\nand height: "))
          (setq cc (polar (polar aa 0 wdth) (* pi 1.5) ht))
          (setq bb (polar aa 0 wdth))
          (setq dd (polar aa (* pi 1.5) ht))
          (command "pline" aa bb cc dd aa cc bb dd "")))
  (setvar "clayer" clay)
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))